<?php
use Carbon\Carbon;
$now = Carbon::now();
?>

<link rel="stylesheet" href="<?php echo e(asset('lib/bootstrap-material-datetimepicker/css/bootstrap-material-datetimepicker.css')); ?>">
<script src="<?php echo e(asset('lib/bootstrap-material-datetimepicker/js/bootstrap-material-datetimepicker.js')); ?>"></script>

<?php if($level->tipo_sosta != 'std'): ?>
<script>
    function computeCost() {
        var params = {
            livello_id: $('input[name="level_id"]').val(),
            data_sosta: $('input[name="from_date"]').val(),
        };
        
        $.post("<?php echo e(url('api/parks/compute-cost')); ?>", params, function(data) {
            try {
                var res = JSON.parse(data);

                if (res.success) {
                    $('#to-date').val(res.content.data_end).parents('.form-group').removeClass('d-none');
                    $('#park-cost').val(res.content.c_fina).parents('.row').removeClass('d-none');
                } else {
                    $('#to-date').val('').parents('.form-group').addClass('d-none');
                    $('#park-cost').val('').parents('.row').addClass('d-none');
                }
                
                var confirmButton = $('.btn#confirm');
                if (res.disable) {
                    confirmButton.attr('disabled', 'disabled');
                    showError(res.content);
                } else {
                    confirmButton.removeAttr('disabled');
                    showPayButton();
                }
            } catch (e) {
                //
            }
        });
    }
</script>

<?php else: ?>

<script>
    function computeCost() {
        var params = {
            livello_id: $('input[name="level_id"]').val(),
            data_sosta: $('input[name="park_date"]').val(),
            dalle_ore: $('#from-time').val(),
            alle_ore: $('#to-time').val()
        };
        
        $.post("<?php echo e(url('api/parks/compute-cost')); ?>", params, function(data) {
            try {
                var res = JSON.parse(data);

                if (res.success) {
                    $('#park-cost').val(res.content).parents('.row').removeClass('d-none');
                } else {
                    $('#park-cost').val('').parents('.row').addClass('d-none');
                }
                
                var confirmButton = $('.btn.btn-outline-primary');
                if (res.disable) {
                    confirmButton.attr('disabled', 'disabled');
                    showError(res.content);
                } else {
                    confirmButton.removeAttr('disabled');
                    showPayButton();
                }
            } catch (e) {
                //
            }
        });
    }
</script>
<?php endif; ?>

<input type="hidden" name="park_date" id="park-date" value="<?php echo e($now->format('d/m/Y')); ?>">

<?php if($level->tipo_sosta == 'std'): ?>

<h5>Tempo di sosta</h5>
<div class="form-group">
    <label for="from-time" class="sr-only">Dalle ore</label>
    <input type="text" name="from_time" id="from-time" class="form-control" placeholder="Dalle ore" rautocomplete="off" equired>
</div>
<div class="form-group">
    <label for="to-time" class="sr-only">Alle ore</label>
    <input type="text" name="to_time" id="to-time" class="form-control" placeholder="Alle ore" autocomplete="off" required>
</div>
<script>
    $(document).ready(function() {
        var options = {
            date: false,
            format: 'HH:mm',
            switchOnClick: true
        };
        $('#to-time').on('change', function() {
            computeCost();
        }).bootstrapMaterialDatePicker(options);
        
        options.currentDate = new Date();
        $('#from-time').on('change', function() {
            computeCost();
        }).bootstrapMaterialDatePicker(options);
        
        $('input[name="park_date"]').val(moment().format('D/M/YYYY'));
    });
</script>

<?php endif; ?>




<?php if($level->tipo_sosta == 'gio'): ?>

<h5>Ora di inizio sosta</h5>
<div class="form-group">
    <label for="from-time" class="sr-only">Dalle ore</label>
    <input type="text" name="from_time" id="from-time" class="form-control" placeholder="Dalle ore" autocomplete="off" required>
</div>
<div class="form-group d-none">
    <label for="to-time" class="sr-only">Alle ore</label>
    <input type="text" name="to_time" id="to-time" class="form-control" placeholder="Alle ore" autocomplete="off" required>
</div>
<script>
    $(document).ready(function() {
        var options = {
            date: false,
            format: 'HH:mm',
            switchOnClick: true
        };

        $('#from-time').on('change', function() {
            var params = {
                livello_id: $('input[name="level_id"]').val(),
                data_sosta: $('input[name="park_date"]').val(),
                dalle_ore: $('#from-time').val()
            };

            $.post("<?php echo e(url('api/parks/compute-cost')); ?>", params, function(data) {
                try {
                    var res = JSON.parse(data);

                    if (res.success) {
                        $('#to-time').val(res.content.data_ora_end).parents('.form-group').removeClass('d-none');
                        $('#park-cost').val(res.content.c_fina).parents('.row').removeClass('d-none');
                    } else {
                        $('#to-time').val('').parents('.form-group').addClass('d-none');
                        $('#park-cost').val('').parents('.row').addClass('d-none');
                    }

                    var confirmButton = $('.btn.btn-outline-primary');
                    if (res.disable) {
                        confirmButton.attr('disabled', 'disabled');
                        showError(res.content);
                    } else {
                        confirmButton.removeAttr('disabled');
                        showPayButton();
                    }
                } catch (e) {
                    //
                }
            });
        }).bootstrapMaterialDatePicker(options);
    });
</script>

<?php endif; ?>




<?php if($level->tipo_sosta == 'fse'): ?>
<h5>Fine settimana (Ven-Dom)</h5>
<div class="form-group">
    <label for="from-date" class="sr-only">Da venerd&igrave;</label>
    <input type="text" name="from_date" id="from-date" class="form-control" placeholder="Da venerd&igrave;" rautocomplete="off" equired>
</div>
<div class="form-group">
    <label for="to-date" class="sr-only">A domenica</label>
    <input type="text" name="to_date" id="to-date" class="form-control" placeholder="A domenica" autocomplete="off" required>
</div>
<script>
    $(document).ready(function() {
        var options = {
            time:           false,
            format:         'DD/MM/YYYY',
            switchOnClick:  true,
            minDate:        new Date(),
            lang:           'it',
            weekStart:      1,
            disabledDays:   [1, 2, 3, 4, 6, 7]
        };
        $('#from-date').on('change', function() {
            $('input[name="park_date"]').val($(this).val());
            computeCost();
        }).bootstrapMaterialDatePicker(options);
    });
</script>
<?php endif; ?>




<?php if($level->tipo_sosta == 'set'): ?>
<h5>Settimana</h5>
<div class="form-group">
        <label for="from-date" class="sr-only">Da</label>
        <input type="text" name="from_date" id="from-date" class="form-control" placeholder="Da" autocomplete="off" required>
    </div>
    <div class="form-group">
        <label for="to-date" class="sr-only">A</label>
        <input type="text" name="to_date" id="to-date" class="form-control" placeholder="A" autocomplete="off" required readonly>
    </div>
<script>
    $(document).ready(function() {
        var options = {
            time:           false,
            format:         'DD/MM/YYYY',
            switchOnClick:  true,
            minDate:        new Date(),
            lang:           'it',
            weekStart:      1
        };
        $('#from-date').on('change', function() {
            $('input[name="data_sosta"]').val($(this).val());
            computeCost();
        }).bootstrapMaterialDatePicker(options);
    });
</script>
<?php endif; ?>




<?php if($level->tipo_sosta == 'men'): ?>
<h5>Mese</h5>
<div class="form-group">
        <label for="from-date" class="sr-only">Da</label>
        <input type="text" name="from_date" id="from-date" class="form-control" placeholder="Da" rautocomplete="off" equired>
    </div>
    <div class="form-group">
        <label for="to-date" class="sr-only">A</label>
        <input type="text" name="to_date" id="to-date" class="form-control" placeholder="A" autocomplete="off" required>
    </div>
<script>
    $(document).ready(function() {
        var options = {
            time:           false,
            format:         'DD/MM/YYYY',
            switchOnClick:  true,
            minDate:        new Date(),
            lang:           'it',
            weekStart:      1
        };
        $('#from-date').on('change', function() {
            $('input[name="data_sosta]').val($(this).val());
            computeCost();
        }).bootstrapMaterialDatePicker(options);
    });
</script>
<?php endif; ?>
