<?php

Route::get('/', function() {
    return view('welcome');
});

Route::get('user/create', 'UserController@create');
Route::post('user/create', 'UserController@store');

Route::get('park/create', 'ParkController@create');
Route::post('park/create', 'ParkController@store');

Route::group(['prefix' => 'payment'], function() {
    
    Route::get('result', 'PaymentController@result');
    Route::get('create', 'PaymentController@create');
    Route::get('execute', 'PaymentController@execute');
});
    
Route::group(['prefix' => 'tools'], function() {
    
    Route::get('session', function() {
        dd(session()->all());
    });
    Route::get('session/flush', function() {
        session()->flush();
        return redirect('session');
    });
    Route::get('emails/parks/{park}/created', function(App\Models\Park $park) {
        return new App\Mail\ParkCreated($park);
    });
});
