<!doctype html>
<html lang="{{ app()->getLocale() }}">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>{{ config('app.name') }}</title>

        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
        
        <style>
            html,
            body {
              height: 100%;
            }
            body {
              display: -ms-flexbox;
              display: flex;
              -ms-flex-align: center;
              align-items: center;
              padding-top: 40px;
              padding-bottom: 40px;
              background-color: white;
              flex-direction: column;
            }
            .form-signin {
              width: 100%;
              max-width: 330px;
              padding: 15px;
              margin: auto;
            }
            .form-signin .checkbox {
              font-weight: 400;
            }
            .form-signin .form-control {
              position: relative;
              box-sizing: border-box;
              height: auto;
              padding: 10px;
              font-size: 16px;
            }
            .form-signin .form-control:focus {
              z-index: 2;
            }
            .form-signin input[type="email"] {
              margin-bottom: -1px;
              border-bottom-right-radius: 0;
              border-bottom-left-radius: 0;
            }
            .form-signin input[type="password"] {
              margin-bottom: 10px;
              border-top-left-radius: 0;
              border-top-right-radius: 0;
            }
        </style>
    </head>

    <body class="text-center">
        <form action="{{ url('user/create') }}" method="post" class="form-signin">
            {{ csrf_field() }}
        
            <img class="mb-4 logo rounded" src="{{ asset('/img/logo.png') }}" alt="" width="72" height="72">
            
            <h1 class="h3 mb-3 font-weight-normal">Paga subito</h1>
            
            <div class="form-group">
                <label for="email" class="sr-only">Indirizzo email</label>
                <input type="email" 
                    id="email" 
                    name="email"
                    class="form-control" 
                    placeholder="Indirizzo email" 
                    autocomplete="off"
                    value="{{ old('email') }}"
                    required 
                    autofocus>
                
                <label for="mobile" class="sr-only">Cellulare</label>
                <input type="text" 
                    id="mobile" 
                    name="mobile"
                    class="form-control @if ($errors->has('mobile')) is-invalid @endif" 
                    placeholder="Cellulare" 
                    value="{{ old('mobile') }}"
                    autocomplete="off"
                    required>
                @if ($errors->has('mobile'))<div class="invalid-feedback">{{$errors->first('mobile')}}</div>@endif
            </div>
            
            <button class="btn btn-lg btn-primary btn-block" type="submit" data-action="{{ url('user/create') }}">Crea sosta</button>
            <!--<button class="btn btn-lg btn-outline-secondary btn-block" type="button" data-action="{{ url('park/show') }}">Le tue soste</button>-->
        
            <p class="mt-5 mb-3 text-muted">Ditech Mobility &copy; 2019</p>
        </form>
        
<!--        <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
        <script>
            $(document).ready(function() {
                $('.btn[data-action]').click(function() {
                    $('.form-signin').attr('action', $(this).data('action'))
                            .submit();
                });
            });
        </script>-->
    </body>
</html>
