@php
use App\Library\FinancialLib;
use Carbon\Carbon;
@endphp

@extends('layouts.app')

@section('style')
<style>
#map { height: 300px; }
#map p { text-align: center; line-height: 300px; }
#map p img { vertical-align: middle; margin-right: 1rem; }
h5 { margin-top: 1rem; }
</style>
@endsection

@section('content')
<div class="container-fluid">
    @if (!is_null($message))
    <div class="alert alert-{{ $message->type }} alert-dismissible fade show" role="alert">
        <h4 class="alert-heading">Esito</h4>
        <hr>
        <p class="mb-1">{!! $message->text !!}</p>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    @endif
</div>

@if ($parkItem && $message->type == 'success')
<div id="map">
    <p>
        <img src="{{ asset('img/ajax-loader.gif') }}">
        <span>Caricamento mappa...</span>
    </p>
</div>

@php
list($lat, $lng) = explode(',', $parkItem->latlng);
@endphp

<div class="container-fluid">
    <div class="row">
        <div class="col-sm">
            <h5>Ecco dove hai parcheggiato</h5>
            <div id="address">
                <p></p>
                <p><a href="https://www.google.com/maps/search/?api=1&query={{ $parkItem->latlng }}" class="btn btn-block btn-outline-success" target="_blank">Avvia navigazione</a></p>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm">
            <h5>Veicolo</h5>
            <p>{{ $parkItem->vehicle->targa }}</p>
        </div>
    </div>
    @php 
    switch ($parkItem->level->tipo_sosta) {
        case 'gio':
            $parkType = "Giornaliera";
            break;
        case 'fse':
            $parkType = "Fine settimanale (Ven-Dom)";
            break;
        case 'set':
            $parkType = "Settimanale";
            break;
        case 'men':
            $parkType = "Mensile";
            break;
        default:
            $parkType = "";
    }
    @endphp
    
    <div class="row">
        <div class="col-sm">
            <h5>Intervallo sosta</h5>
            <p>{{ $parkType }}</p>
            <div class="row">
                @php
                $start = Carbon::createFromFormat('Y-m-d H:i:s', $parkItem->inizio);
                $end = Carbon::createFromFormat('Y-m-d H:i:s', $parkItem->fine);
                @endphp
                <div class="col-sm">Inizio: {{ $start->format('d/m/Y H:i:s') }}</div>
                <div class="col-sm">Fine: {{ $end->format('d/m/Y H:i:s') }}</div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm">
            <h5>Importo</h5>
            <p>{!! FinancialLib::centToEuro($parkItem->costo, true) !!}</p>
        </div>
    </div>
</div>

<script type="text/javascript">
function init() {
    var point = {
        lat: {{ $lat }},
        lng: {{ $lng }}   
    };

    var map_container = document.getElementById('map'),
        options = {
            center: point,
            mapTypeControlOptions: { 
                mapTypeIds: [google.maps.MapTypeId.ROAD_MAP] 
            },
            streetViewControl: false,
            zoom: 17
        },
        map = new google.maps.Map(map_container, options),
        marker = new google.maps.Marker({
            position: point,
            map: map,
            draggable: false,
            icon: "{{ asset('/img/placeholder.png') }}"
        });
        
    map.addListener('dragend', function() {
        var position = marker.getPosition();

        map.panTo(position);
    });

    getPositionAddress(marker.getPosition());
}

function getPositionAddress(position) {
    var point = new google.maps.LatLng({ lat: position.lat(), lng: position.lng() });

    var geocoder = new google.maps.Geocoder();
    geocoder.geocode({ location: point }, function (results, status) {
        if (status == google.maps.GeocoderStatus.OK) {
            if (results[0]) {
                document.querySelector('#address p').innerText = results[0].formatted_address;
            }
        }
    });
}
</script>
<script src="https://maps.googleapis.com/maps/api/js?key={{ config('google.maps_api_key') }}&libraries=geometry&callback=init" async defer></script>
@endif

<div class="container-fluid">
    <div class="row">
        <div class="col-sm mb-3">
            <a href="{{ url('/') }}" class="btn btn-outline-primary btn-block">Crea nuova sosta</a>
        </div>
    </div>
</div>

@php
unset($message);
@endphp

@endsection
