<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Vehicle;
use App\Models\Level;
use App\Models\User;

class Park extends Model
{
    protected $table = 'spl_soste';
    protected $fillable = [ 
        'utente_id', 
        'livello_id', 
        'veicolo_id',
        'latlng',
        'inizio',
        'fine',
        'costo',
        'stato',
        'fast',
    ];
    
    const PARK_CREATED      = 0;
    const PARK_ACTIVATED    = 1;
    const PARK_EXTENDED     = 2;
    const PARK_ENDED        = 3;
    
    public function vehicle() {
        return $this->belongsTo(Vehicle::class, 'veicolo_id');
    }
    
    public function level() {
        return $this->belongsTo(Level::class, 'livello_id');
    }
    
    public function user() {
        return $this->belongsTo(User::class, 'utente_id');
    }
}
